/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.whatsnew.business;

import fr.paris.lutece.plugins.whatsnew.business.IWhatsNewDAO;
import fr.paris.lutece.plugins.whatsnew.business.WhatsNew;
import fr.paris.lutece.util.sql.DAOUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class WhatsNewDAO
implements IWhatsNewDAO {
    private static final String SQL_QUERY_SELECT_DOCUMENTS_BY_CRITERIAS = "SELECT a.title, a.summary as description, a.date_modification, a.id_document, b.id_portlet FROM document a, document_published b WHERE (a.id_document=b.id_document) AND (a.date_modification between ? AND ?) AND (a.date_validity_begin is null or ?>a.date_validity_begin) AND (a.date_validity_end is null or ?<a.date_validity_end)";
    private static final String SQL_QUERY_SELECT_PORTLETS_BY_CRITERIAS = "SELECT a.name as title,'',a.date_update, a.id_page, a.id_portlet FROM core_portlet a WHERE a.date_update between ? AND ?";
    private static final String SQL_QUERY_SELECT_PAGES_BY_CRITERIAS = "SELECT a.name as title, a.description, a.date_update, a.id_page FROM core_page a WHERE a.date_update between ? AND ?";

    public Collection selectDocumentsByCriterias(Timestamp dateLimit) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT_DOCUMENTS_BY_CRITERIAS);
        Timestamp timestampCurrent = new Timestamp(new Date().getTime());
        daoUtil.setTimestamp(1, dateLimit);
        daoUtil.setTimestamp(2, timestampCurrent);
        daoUtil.setTimestamp(3, timestampCurrent);
        daoUtil.setTimestamp(4, timestampCurrent);
        daoUtil.executeQuery();
        ArrayList<WhatsNew> list = new ArrayList<WhatsNew>();
        while (daoUtil.next()) {
            WhatsNew whatsnew = new WhatsNew();
            whatsnew.setType(0);
            whatsnew.setTitle(daoUtil.getString(1));
            whatsnew.setDescription(daoUtil.getString(2));
            whatsnew.setDateUpdate(daoUtil.getTimestamp(3));
            whatsnew.setDocumentId(daoUtil.getInt(4));
            whatsnew.setPortletId(daoUtil.getInt(5));
            list.add(whatsnew);
        }
        daoUtil.free();
        return list;
    }

    public Collection selectPortletsByCriterias(Timestamp dateLimit) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT_PORTLETS_BY_CRITERIAS);
        Timestamp timestampCurrent = new Timestamp(new Date().getTime());
        daoUtil.setTimestamp(1, dateLimit);
        daoUtil.setTimestamp(2, timestampCurrent);
        daoUtil.executeQuery();
        ArrayList<WhatsNew> list = new ArrayList<WhatsNew>();
        while (daoUtil.next()) {
            WhatsNew whatsnew = new WhatsNew();
            whatsnew.setType(1);
            whatsnew.setTitle(daoUtil.getString(1));
            whatsnew.setDescription(daoUtil.getString(2));
            whatsnew.setDateUpdate(daoUtil.getTimestamp(3));
            whatsnew.setPageId(daoUtil.getInt(4));
            whatsnew.setPortletId(daoUtil.getInt(5));
            list.add(whatsnew);
        }
        daoUtil.free();
        return list;
    }

    public Collection selectPagesByCriterias(Timestamp dateLimit) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT_PAGES_BY_CRITERIAS);
        Timestamp timestampCurrent = new Timestamp(new Date().getTime());
        daoUtil.setTimestamp(1, dateLimit);
        daoUtil.setTimestamp(2, timestampCurrent);
        daoUtil.executeQuery();
        ArrayList<WhatsNew> list = new ArrayList<WhatsNew>();
        while (daoUtil.next()) {
            WhatsNew whatsnew = new WhatsNew();
            whatsnew.setType(2);
            whatsnew.setTitle(daoUtil.getString(1));
            whatsnew.setDescription(daoUtil.getString(2));
            whatsnew.setDateUpdate(daoUtil.getTimestamp(3));
            whatsnew.setPageId(daoUtil.getInt(4));
            list.add(whatsnew);
        }
        daoUtil.free();
        return list;
    }
}

