/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.whatsnew.business.portlet;

import fr.paris.lutece.plugins.whatsnew.business.WhatsNew;
import fr.paris.lutece.plugins.whatsnew.business.WhatsNewHome;
import fr.paris.lutece.plugins.whatsnew.business.portlet.WhatsNewPortletHome;
import fr.paris.lutece.portal.business.portlet.Portlet;
import fr.paris.lutece.util.xml.XmlUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class WhatsNewPortlet
extends Portlet {
    public static final int ELEMENT_ORDER_DATE_DESC = 0;
    public static final int ELEMENT_ORDER_DATE_ASC = 1;
    public static final int ELEMENT_ORDER_ALPHA = 2;
    private static final String TAG_WHATS_NEW_PORTLET = "whatsnew-list-portlet";
    private static final String TAG_WHATS_NEW_MIN_DISPLAY = "whatsnew-min-display";
    private static final String TAG_WHATS_NEW_NUMBER_DISPLAY = "whatsnew-number-display";
    private static final String PARAMETER_MIN_DISPLAY = "min_display";
    private static final Comparator COMPARATOR_TRI_ASC = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            WhatsNew whatsnew1 = (WhatsNew)obj1;
            WhatsNew whatsnew2 = (WhatsNew)obj2;
            int nDateOrder = whatsnew1.getDateUpdate().compareTo(whatsnew2.getDateUpdate());
            return nDateOrder;
        }
    };
    private static final Comparator COMPARATOR_TRI_DESC = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            WhatsNew whatsnew1 = (WhatsNew)obj1;
            WhatsNew whatsnew2 = (WhatsNew)obj2;
            int nDateOrder = whatsnew1.getDateUpdate().compareTo(whatsnew2.getDateUpdate());
            if (nDateOrder != 0) {
                nDateOrder = -nDateOrder;
            }
            return nDateOrder;
        }
    };
    private static final Comparator COMPARATOR_TRI_ALPHA = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            WhatsNew whatsnew1 = (WhatsNew)obj1;
            WhatsNew whatsnew2 = (WhatsNew)obj2;
            int nDateOrder = whatsnew1.getTitle().toUpperCase().compareTo(whatsnew2.getTitle().toUpperCase());
            return nDateOrder;
        }
    };
    private boolean _bShowDocuments;
    private boolean _bShowPortlets;
    private boolean _bShowPages;
    private int _nPeriod;
    private int _nNbElementsMax;
    private int _nElementsOrder;

    public WhatsNewPortlet() {
        this.setPortletTypeId(WhatsNewPortletHome.getInstance().getPortletTypeId());
    }

    public boolean getShowDocuments() {
        return this._bShowDocuments;
    }

    public void setShowDocuments(boolean bShowDocuments) {
        this._bShowDocuments = bShowDocuments;
    }

    public boolean getShowPortlets() {
        return this._bShowPortlets;
    }

    public void setShowPortlets(boolean bPortlets) {
        this._bShowPortlets = bPortlets;
    }

    public boolean getShowPages() {
        return this._bShowPages;
    }

    public void setShowPages(boolean bPages) {
        this._bShowPages = bPages;
    }

    public int getPeriod() {
        return this._nPeriod;
    }

    public void setPeriod(int nPeriod) {
        this._nPeriod = nPeriod;
    }

    public int getNbElementsMax() {
        return this._nNbElementsMax;
    }

    public void setNbElementsMax(int nElementsMax) {
        this._nNbElementsMax = nElementsMax;
    }

    public int getElementsOrder() {
        return this._nElementsOrder;
    }

    public void setElementsOrder(int nOrder) {
        this._nElementsOrder = nOrder;
    }

    public String getXmlDocument(HttpServletRequest request) {
        return XmlUtil.getXmlHeader() + this.getXml(request);
    }

    public String getXml(HttpServletRequest request) {
        int comparator;
        StringBuffer strXml = new StringBuffer();
        XmlUtil.beginElement((StringBuffer)strXml, (String)TAG_WHATS_NEW_PORTLET);
        ArrayList listElements = new ArrayList();
        Timestamp limitTimestamp = this.getTimestampFromPeriodAndCurrentDate(this.getPeriod());
        if (this.getShowDocuments()) {
            Collection listDocuments = WhatsNewHome.selectDocumentsByCriterias(limitTimestamp);
            listElements.addAll(listDocuments);
        }
        if (this.getShowPortlets()) {
            Collection listPortlets = WhatsNewHome.selectPortletsByCriterias(limitTimestamp);
            listElements.addAll(listPortlets);
        }
        if (this.getShowPages()) {
            Collection listPages = WhatsNewHome.selectPagesByCriterias(limitTimestamp);
            listElements.addAll(listPages);
        }
        if ((comparator = this.getElementsOrder()) == 0) {
            Collections.sort(listElements, COMPARATOR_TRI_DESC);
        } else if (comparator == 1) {
            Collections.sort(listElements, COMPARATOR_TRI_ASC);
        } else if (comparator == 2) {
            Collections.sort(listElements, COMPARATOR_TRI_ALPHA);
        } else {
            Collections.sort(listElements, COMPARATOR_TRI_DESC);
        }
        Iterator i = listElements.iterator();
        String strMinDisplay = null;
        if (request != null) {
            strMinDisplay = request.getParameter("min_display_" + this.getId());
        }
        if (strMinDisplay != null) {
            XmlUtil.addElement((StringBuffer)strXml, (String)TAG_WHATS_NEW_MIN_DISPLAY, strMinDisplay);
        } else {
            XmlUtil.addElement((StringBuffer)strXml, (String)TAG_WHATS_NEW_MIN_DISPLAY, (int)1);
        }
        XmlUtil.addElement((StringBuffer)strXml, (String)TAG_WHATS_NEW_NUMBER_DISPLAY, (int)this.getNbElementsMax());
        while (i.hasNext()) {
            WhatsNew whatsnew = (WhatsNew)i.next();
            strXml.append(whatsnew.getXml(request));
        }
        XmlUtil.endElement((StringBuffer)strXml, (String)TAG_WHATS_NEW_PORTLET);
        return this.addPortletTags(strXml);
    }

    public void update() {
        WhatsNewPortletHome.getInstance().update((Portlet)this);
    }

    public void remove() {
        WhatsNewPortletHome.getInstance().remove((Portlet)this);
    }

    private Timestamp getTimestampFromPeriodAndCurrentDate(int nDays) {
        GregorianCalendar currentCalendar = new GregorianCalendar(Locale.FRANCE);
        currentCalendar.set(11, 0);
        currentCalendar.set(12, 0);
        currentCalendar.set(13, 0);
        currentCalendar.set(14, 0);
        ((Calendar)currentCalendar).add(5, -nDays);
        Timestamp timestampCurrent = new Timestamp(currentCalendar.getTimeInMillis());
        return timestampCurrent;
    }
}

