/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.whatsnew.business.portlet;

import fr.paris.lutece.plugins.whatsnew.business.portlet.IWhatsNewPortletDAO;
import fr.paris.lutece.plugins.whatsnew.business.portlet.WhatsNewPortlet;
import fr.paris.lutece.portal.business.portlet.Portlet;
import fr.paris.lutece.util.sql.DAOUtil;

public final class WhatsNewPortletDAO
implements IWhatsNewPortletDAO {
    private static final String SQL_QUERY_INSERT = "INSERT INTO whatsnew_portlet (id_portlet, show_documents, show_portlets, show_pages, period, nb_elements_max, elements_order) VALUES ( ?,?,?,?,?,?,? )";
    private static final String SQL_QUERY_DELETE = "DELETE FROM whatsnew_portlet WHERE id_portlet = ?";
    private static final String SQL_QUERY_SELECT = "SELECT id_portlet, show_documents, show_portlets, show_pages, period, nb_elements_max, elements_order FROM whatsnew_portlet WHERE id_portlet = ?";
    private static final String SQL_QUERY_UPDATE = "UPDATE whatsnew_portlet SET show_documents = ?, show_portlets = ?, show_pages = ?, period = ?, nb_elements_max = ?, elements_order = ? WHERE id_portlet = ?";

    public void insert(Portlet portlet) {
        WhatsNewPortlet p = (WhatsNewPortlet)portlet;
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_INSERT);
        daoUtil.setInt(1, p.getId());
        if (p.getShowDocuments()) {
            daoUtil.setInt(2, 1);
        } else {
            daoUtil.setInt(2, 0);
        }
        if (p.getShowPortlets()) {
            daoUtil.setInt(3, 1);
        } else {
            daoUtil.setInt(3, 0);
        }
        if (p.getShowPages()) {
            daoUtil.setInt(4, 1);
        } else {
            daoUtil.setInt(4, 0);
        }
        daoUtil.setInt(5, p.getPeriod());
        daoUtil.setInt(6, p.getNbElementsMax());
        daoUtil.setInt(7, p.getElementsOrder());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    public void delete(int nPortletId) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_DELETE);
        daoUtil.setInt(1, nPortletId);
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    public Portlet load(int nPortletId) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT);
        daoUtil.setInt(1, nPortletId);
        daoUtil.executeQuery();
        WhatsNewPortlet portlet = new WhatsNewPortlet();
        if (daoUtil.next()) {
            portlet.setId(daoUtil.getInt(1));
            if (daoUtil.getInt(2) == 0) {
                portlet.setShowDocuments(false);
            } else {
                portlet.setShowDocuments(true);
            }
            if (daoUtil.getInt(3) == 0) {
                portlet.setShowPortlets(false);
            } else {
                portlet.setShowPortlets(true);
            }
            if (daoUtil.getInt(4) == 0) {
                portlet.setShowPages(false);
            } else {
                portlet.setShowPages(true);
            }
            portlet.setPeriod(daoUtil.getInt(5));
            portlet.setNbElementsMax(daoUtil.getInt(6));
            portlet.setElementsOrder(daoUtil.getInt(7));
        }
        daoUtil.free();
        return portlet;
    }

    public void store(Portlet portlet) {
        WhatsNewPortlet p = (WhatsNewPortlet)portlet;
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_UPDATE);
        if (p.getShowDocuments()) {
            daoUtil.setInt(1, 1);
        } else {
            daoUtil.setInt(1, 0);
        }
        if (p.getShowPortlets()) {
            daoUtil.setInt(2, 1);
        } else {
            daoUtil.setInt(2, 0);
        }
        if (p.getShowPages()) {
            daoUtil.setInt(3, 1);
        } else {
            daoUtil.setInt(3, 0);
        }
        daoUtil.setInt(4, p.getPeriod());
        daoUtil.setInt(5, p.getNbElementsMax());
        daoUtil.setInt(6, p.getElementsOrder());
        daoUtil.setInt(7, p.getId());
        daoUtil.executeUpdate();
        daoUtil.free();
    }
}

