/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.whatsnew.web.portlet;

import fr.paris.lutece.plugins.whatsnew.business.portlet.WhatsNewPortlet;
import fr.paris.lutece.plugins.whatsnew.business.portlet.WhatsNewPortletHome;
import fr.paris.lutece.portal.business.portlet.Portlet;
import fr.paris.lutece.portal.business.portlet.PortletHome;
import fr.paris.lutece.portal.service.message.AdminMessageService;
import fr.paris.lutece.portal.service.util.AppPropertiesService;
import fr.paris.lutece.portal.web.portlet.PortletJspBean;
import fr.paris.lutece.util.ReferenceList;
import fr.paris.lutece.util.html.HtmlTemplate;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class WhatsNewPortletJspBean
extends PortletJspBean {
    public static final String RIGHT_MANAGE_ADMIN_SITE = "CORE_ADMIN_SITE";
    private static final String MESSAGE_MANDATORY_PORTLET_NB_ELEMENTS_MAX = "whatsnew.message.portlet.nbelementsmax.mandatory";
    private static final String MESSAGE_NOT_VALID_PORTLET_NB_ELEMENTS_MAX = "whatsnew.message.portlet.nbelementsmax.not.valid";
    private static final String MESSAGE_NEGATIVE_PORTLET_NB_ELEMENTS_MAX = "whatsnew.message.portlet.nbelementsmax.negative";
    private static final String PARAMETER_PAGE_ID = "page_id";
    private static final String PARAMETER_PORTLET_ID = "portlet_id";
    private static final String PARAMETER_SHOW_DOCUMENTS = "checkbox_documents";
    private static final String PARAMETER_SHOW_PORTLETS = "checkbox_portlets";
    private static final String PARAMETER_SHOW_PAGES = "checkbox_pages";
    private static final String PARAMETER_PERIOD = "text_period";
    private static final String PARAMETER_NB_ELEMENTS_MAX = "text_nbElements";
    private static final String PARAMETER_ELEMENTS_ORDER = "display_order";
    private static final String PARAMETER_PORTLET_TYPE_ID = "portlet_type_id";
    private static final String MARK_COMBO_PERIOD = "combo_period";
    private static final String MARK_DEFAULT_PERIOD = "default_period";
    private static final String MARK_VALUE_DESC = "value_desc";
    private static final String MARK_VALUE_ASC = "value_asc";
    private static final String MARK_VALUE_ALPHA = "value_alpha";
    private static final String MARK_CHECKED_DOCUMENTS = "checked_documents";
    private static final String MARK_CHECKED_PORTLETS = "checked_portlets";
    private static final String MARK_CHECKED_PAGES = "checked_pages";
    private static final String MARK_NB_ELEMENTS_MAX = "nbElements";
    private static final String MARK_CHECKED_ORDER_DESC = "checked_desc";
    private static final String MARK_CHECKED_ORDER_ASC = "checked_asc";
    private static final String MARK_CHECKED_ORDER_ALPHA = "checked_alpha";
    private static final String MARK_TYPE_ARTICLE = "type_article";
    private static final String MARK_TYPE_FICHE = "type_permanent_article";
    private static final String MARK_TYPE_PORTLET = "type_portlet";
    private static final String MARK_TYPE_PAGE = "type_page";
    private static final String PROPERTY_FRAGMENT_DAYS_COMBO_LIST = ".days.combo.list";
    private static final String PROPERTY_FRAGMENT_DAYS_COMBO_DEFAULT_VALUE = ".days.combo.default.value";
    private static final String CONSTANT_CHECKED = "checked";
    private static final String CONSTANT_EMPTY_STRING = "";
    private static final String CONSTANT_DELIMITER_SEMI_COLON = ";";
    private static final String CONSTANT_DELIMITER_COMA = ",";

    public String getCreate(HttpServletRequest request) {
        String strPageId = request.getParameter(PARAMETER_PAGE_ID);
        String strPortletTypeId = request.getParameter(PARAMETER_PORTLET_TYPE_ID);
        HashMap model = new HashMap();
        String strPeriodByDefault = AppPropertiesService.getProperty((String)(this.getPropertiesPrefix() + PROPERTY_FRAGMENT_DAYS_COMBO_DEFAULT_VALUE));
        model.put(MARK_COMBO_PERIOD, this.getComboDays());
        model.put(MARK_DEFAULT_PERIOD, String.valueOf(Integer.parseInt(strPeriodByDefault)));
        model = this.initializePortlet(model);
        HtmlTemplate template = this.getCreateTemplate(strPageId, strPortletTypeId, model);
        return template.getHtml();
    }

    public String getModify(HttpServletRequest request) {
        String strPortletId = request.getParameter(PARAMETER_PORTLET_ID);
        int nPortletId = Integer.parseInt(strPortletId);
        WhatsNewPortlet portlet = (WhatsNewPortlet)PortletHome.findByPrimaryKey((int)nPortletId);
        HashMap model = new HashMap();
        model.put(MARK_COMBO_PERIOD, this.getComboDays());
        model.put(MARK_DEFAULT_PERIOD, String.valueOf(portlet.getPeriod()));
        model = this.initializePortlet(model);
        if (portlet.getShowDocuments()) {
            model.put(MARK_CHECKED_DOCUMENTS, CONSTANT_CHECKED);
        } else {
            model.put(MARK_CHECKED_DOCUMENTS, CONSTANT_EMPTY_STRING);
        }
        if (portlet.getShowPortlets()) {
            model.put(MARK_CHECKED_PORTLETS, CONSTANT_CHECKED);
        } else {
            model.put(MARK_CHECKED_PORTLETS, CONSTANT_EMPTY_STRING);
        }
        if (portlet.getShowPages()) {
            model.put(MARK_CHECKED_PAGES, CONSTANT_CHECKED);
        } else {
            model.put(MARK_CHECKED_PAGES, CONSTANT_EMPTY_STRING);
        }
        model.put(MARK_NB_ELEMENTS_MAX, String.valueOf(portlet.getNbElementsMax()));
        if (portlet.getElementsOrder() == 0) {
            model.put(MARK_CHECKED_ORDER_DESC, CONSTANT_CHECKED);
            model.put(MARK_CHECKED_ORDER_ASC, CONSTANT_EMPTY_STRING);
            model.put(MARK_CHECKED_ORDER_ALPHA, CONSTANT_EMPTY_STRING);
        } else if (portlet.getElementsOrder() == 1) {
            model.put(MARK_CHECKED_ORDER_DESC, CONSTANT_EMPTY_STRING);
            model.put(MARK_CHECKED_ORDER_ASC, CONSTANT_CHECKED);
            model.put(MARK_CHECKED_ORDER_ALPHA, CONSTANT_EMPTY_STRING);
        } else if (portlet.getElementsOrder() == 2) {
            model.put(MARK_CHECKED_ORDER_DESC, CONSTANT_EMPTY_STRING);
            model.put(MARK_CHECKED_ORDER_ASC, CONSTANT_EMPTY_STRING);
            model.put(MARK_CHECKED_ORDER_ALPHA, CONSTANT_CHECKED);
        } else {
            model.put(MARK_CHECKED_ORDER_DESC, CONSTANT_CHECKED);
            model.put(MARK_CHECKED_ORDER_ASC, CONSTANT_EMPTY_STRING);
            model.put(MARK_CHECKED_ORDER_ALPHA, CONSTANT_EMPTY_STRING);
        }
        HtmlTemplate template = this.getModifyTemplate(portlet, model);
        return template.getHtml();
    }

    public String doCreate(HttpServletRequest request) {
        WhatsNewPortlet portlet = new WhatsNewPortlet();
        String strIdPage = request.getParameter(PARAMETER_PAGE_ID);
        int nIdPage = Integer.parseInt(strIdPage);
        String strNbElementsMax = request.getParameter(PARAMETER_NB_ELEMENTS_MAX);
        if (strNbElementsMax == null || strNbElementsMax.trim().equals(CONSTANT_EMPTY_STRING)) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_MANDATORY_PORTLET_NB_ELEMENTS_MAX, (int)2);
        }
        try {
            int nNbElementsMax = Integer.parseInt(strNbElementsMax);
            if (nNbElementsMax <= 0) {
                return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_NEGATIVE_PORTLET_NB_ELEMENTS_MAX, (int)2);
            }
        }
        catch (NumberFormatException nb) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_NOT_VALID_PORTLET_NB_ELEMENTS_MAX, (int)2);
        }
        portlet = this.validatePortlet(portlet, request);
        String strErrorUrl = this.setPortletCommonData(request, portlet);
        if (strErrorUrl != null) {
            return strErrorUrl;
        }
        portlet.setPageId(nIdPage);
        WhatsNewPortletHome.getInstance().create((Portlet)portlet);
        return this.getPageUrl(portlet.getPageId());
    }

    public String doModify(HttpServletRequest request) {
        String strPortletId = request.getParameter(PARAMETER_PORTLET_ID);
        int nPortletId = Integer.parseInt(strPortletId);
        WhatsNewPortlet portlet = (WhatsNewPortlet)PortletHome.findByPrimaryKey((int)nPortletId);
        String strNbElementsMax = request.getParameter(PARAMETER_NB_ELEMENTS_MAX);
        if (strNbElementsMax == null || strNbElementsMax.trim().equals(CONSTANT_EMPTY_STRING)) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_MANDATORY_PORTLET_NB_ELEMENTS_MAX, (int)2);
        }
        try {
            int nNbElementsMax = Integer.parseInt(strNbElementsMax);
            if (nNbElementsMax <= 0) {
                return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_NEGATIVE_PORTLET_NB_ELEMENTS_MAX, (int)2);
            }
        }
        catch (NumberFormatException nb) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_NOT_VALID_PORTLET_NB_ELEMENTS_MAX, (int)2);
        }
        portlet = this.validatePortlet(portlet, request);
        String strErrorUrl = this.setPortletCommonData(request, portlet);
        if (strErrorUrl != null) {
            return strErrorUrl;
        }
        portlet.update();
        return this.getPageUrl(portlet.getPageId());
    }

    public String getPropertiesPrefix() {
        return "portlet.whatsnew";
    }

    private ReferenceList getComboDays() {
        String strPropertyNameList = this.getPropertiesPrefix() + PROPERTY_FRAGMENT_DAYS_COMBO_LIST;
        String strListe = AppPropertiesService.getProperty((String)strPropertyNameList);
        ReferenceList comboDaysList = new ReferenceList();
        StringTokenizer strTokSemiColon = new StringTokenizer(strListe, CONSTANT_DELIMITER_SEMI_COLON);
        while (strTokSemiColon.hasMoreTokens()) {
            StringTokenizer strTokComa = new StringTokenizer(strTokSemiColon.nextToken(), CONSTANT_DELIMITER_COMA);
            while (strTokComa.hasMoreTokens()) {
                comboDaysList.addItem(Integer.parseInt(strTokComa.nextToken()), strTokComa.nextToken());
            }
        }
        return comboDaysList;
    }

    private HashMap initializePortlet(HashMap model) {
        model.put(MARK_VALUE_DESC, String.valueOf(0));
        model.put(MARK_VALUE_ASC, String.valueOf(1));
        model.put(MARK_VALUE_ALPHA, String.valueOf(2));
        return model;
    }

    private WhatsNewPortlet validatePortlet(WhatsNewPortlet portlet, HttpServletRequest request) {
        this.setPortletCommonData(request, portlet);
        if (request.getParameter(PARAMETER_SHOW_DOCUMENTS) == null) {
            portlet.setShowDocuments(false);
        } else {
            portlet.setShowDocuments(true);
        }
        if (request.getParameter(PARAMETER_SHOW_PORTLETS) == null) {
            portlet.setShowPortlets(false);
        } else {
            portlet.setShowPortlets(true);
        }
        if (request.getParameter(PARAMETER_SHOW_PAGES) == null) {
            portlet.setShowPages(false);
        } else {
            portlet.setShowPages(true);
        }
        portlet.setPeriod(Integer.parseInt(request.getParameter(PARAMETER_PERIOD)));
        portlet.setNbElementsMax(Integer.parseInt(request.getParameter(PARAMETER_NB_ELEMENTS_MAX)));
        portlet.setElementsOrder(Integer.parseInt(request.getParameter(PARAMETER_ELEMENTS_ORDER)));
        return portlet;
    }
}

